/*******************************************************************************
* Lists Styles in a max file
* Author: Attila Szabo
* Date: Nov.23.2006
*******************************************************************************/

/******************************************************************************
* Lists categories and styles to the Listener
*******************************************************************************/
MacroScript ListStylesASCII
	ButtonText:~LISTSTYLESASCII_BUTTONTEXT~
	Category:"DWG.Interop" 
	internalCategory:"DWG.Interop" 
	Tooltip:~LISTSTYLESASCII_TOOLTIP~ 
(
-- constants
strIndent = "  "

function ListStyle aStyle aStyleIndent = 
(
	format "%%\n" aStyleIndent aStyle.name
	
	components = #()
	aStyle.getComponents &components
	for i=1 to components.count do 
	(
		ListStyle components[i] (aStyleIndent + strIndent)
	)
)

function ListStyles aCategory aStyleIndent = 
(
	styles = #()
	aCategory.getStyles &styles
	for i=1 to styles.count do 
	(
		ListStyle styles[i] aStyleIndent
	)
)

function ListCategories = 
(
	format ~FORMATTED_CATEGORIES_CAPTION~ styleMgr.numCategories
	categories =#()
	styleMgr.GetCategories &categories
	for i=1 to categories.count do 
	(
		format "\n%\n" categories[i].name
		ListStyles categories[i] (strIndent + strIndent)
	)
)

function ListStyleMgr = 
(
	format ~FORMATTED_LIST_OF_STYLES_CAPTION~ (maxFilePath + "\\" + maxFileName)
	ListCategories()
)
	
On Execute Do 
(
	ListStyleMgr()
)

)


/*******************************************************************************
* Lists styles to a Tree View
********************************************************************************/
MacroScript ListStylesGUI
	ButtonText:~LISTSTYLESGUI_BUTTONTEXT~
	Category:"DWG.Interop" 
	internalCategory:"DWG.Interop" 
	Tooltip:~LISTSTYLESGUI_TOOLTIP~ 
(

-- indentation in pixels
kIndentation = 10
kRolloutWidth = 200
kRolloutHeight = 400

rollout theRollout ~ROLLOUT_ADT_STYLES_BROWSER~
(
-- Methods that fill in the tree view with ADT styles	
function AddStyle aTVNode aStyle = 
(
	newTVNode = aTVNode.Nodes.add aStyle.name 
	
	components = #()
	aStyle.getComponents &components
	for i=1 to components.count do 
	(
		AddStyle newTVNode components[i]
	)
)

function AddStyles aTVNode aCategory =
(
	styles = #()
	aCategory.getStyles &styles
	for i=1 to styles.count do 
	(
		AddStyle aTVNode styles[i] 
	)
)

function AddCategories aTVNode = 
(
	categories =#()
	styleMgr.GetCategories &categories
	for i=1 to categories.count do 
	(
		newTVNode = aTVNode.Nodes.add categories[i].name
		AddStyles newTVNode categories[i] 
	)
)

function AddStylesMgr aTreeView =
(
	AddCategories (aTreeView.Nodes.add ~ADT_STYLES~)
)


-- Tree view methods

dotNetControl theTreeView "TreeView" width: (kRolloutWidth-10) height: (kRolloutHeight-10) align:#center
	
function clearTreeView tv = 
(
	tv.Nodes.Clear()
)

function initTreeView tv =
(
	tv.Indent= kIndentation 
	--the default style already has root lines.
)

function FillTreeView aTreeView =
(
	clearTreeView aTreeView
	InitTreeView aTreeView 
	AddStylesMgr aTreeView
)

on theTreeView Click arg do 
(
	--First get the TreeView node below the mouse cursor
	--The arg argument has properties .x and .y with the current pos.
	--Use showProperties arg to see what is available...
	--We use the TreeView method GetNodeAt to see what was clicked:
	hitNode = theTreeView.GetNodeAt (dotNetObject "System.Drawing.Point" arg.x arg.y)
	if hitNode != undefined do --if a TreeView node was clicked,
	(
		-- do something
	)
)

on theRollout open do 
(
	FillTreeView theTreeView
)

on theRollout close do 
(
	callbacks.removeScripts #systemPostReset id:#systemPostResetID
	callbacks.removeScripts #systemPostNew id:#systemPostNewID
	callbacks.removeScripts #filePostOpen id:#filePostOpenID
	callbacks.removeScripts #postImport id:#postImportID
	callbacks.removeScripts #fileLinkPostAttach id:#fileLinkPostAttachID
)

) -- rollout

try 
(
  destroyDialog theRollout
  unRegisterViewWindow theRollout
)
catch()

createDialog theRollout kRolloutWidth kRolloutHeight
registerViewWindow theRollout
callbacks.addScript #systemPostReset "theRollout.FillTreeView theRollout.theTreeView" id:#systemPostResetID
callbacks.addScript #systemPostNew "theRollout.FillTreeView theRollout.theTreeView" id:#systemPostNewID
callbacks.addScript #filePostOpen "theRollout.FillTreeView theRollout.theTreeView" id:#filePostOpenID
callbacks.addScript #postImport "theRollout.FillTreeView theRollout.theTreeView" id:#postImportID
callbacks.addScript #fileLinkPostAttach "theRollout.FillTreeView theRollout.theTreeView" id:#fileLinkPostAttachID
)

-- EOF



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCBT5Iq/dY3qgY7CSMuawYXgaENLxF+UhHq
-- rDIwobxQwX3DImNTiyvx8NyC5IdWtDiLrJuRvgA7dXsUheUwGnu2FUnBmhdFwgMf
-- JTeIfv9QB6lWPnUXa/0jyaJwkE+Wsx6Skpzjr7PGOiiKII0htEyPSBC3Ry8JoBvE
-- 0KaSGD9x2s1Y2uheKzBE4pEiIUWV4VmIZvrqSZ1bAFKbysoQyV2ASjABuXgi4I/W
-- wvHV5XXSAn1G5k4rRcq6HgWG/j4umhqgVsVZwEB3rNgzbkifeNjhrPiHFRIM8IEL
-- HHgGgzwyOAxsmVeSskfFviUqV3TBAQ8exhzeMiqGEzEPmYoVGIbx
-- -----END-SIGNATURE-----